Class("DynamicBackground",{statics:{create:function(a){var b=DynamicBackground.initAnimation(a),c=a.width,d=a.height;(function(){if(c!=windowWidth||d!=windowHeight)c=windowWidth,d=windowHeight,b.resize(c,d);b.nextFrame()}).animation();return b},initAnimation:function(a){switch(a.name){case "PetalsDancing":return new PetalsDancingAnimation(a);case "Snow":return new SnowAnimation(a);case "SlowBubble":return new SlowBubbleAnimation(a);case "FastBubble":return new FastBubbleAnimation(a);case "LightRain":return new LightRainAnimation(a);
case "HeavyRain":return new HeavyRainAnimation(a);case "Firefly":return new FireflyAnimation(a);case "SpaceShip":return new SpaceShipAnimation(a);case "SpaceTravel":return new SpaceTravelAnimation(a);case "Cloud":return new CloudAnimation(a);case "SunCloud":return new SunCloudAnimation(a);case "Meteor":return new MeteorAnimation(a);case "Sunshine":return new SunshineAnimation(a);case "Twinkle":return new TwinkleAnimation(a);case "FallenLeaves":return new FallenLeavesAnimation(a);case "Moon":return new MoonCloudAnimation(a);
case "Balloon":return new BalloonCloudAnimation(a);case "AirBubble":return new SlowBubbleAnimation(a);case "BlinkStar":return new TwinkleAnimation(a);case "CloudsLeft02":return new CloudAnimation(a);case "CloudsLeft02":return new CloudAnimation(a);case "Leaves02":return new FallenLeavesAnimation(a);case "Leaves03":return new FallenLeavesAnimation(a);case "RainDrop":return new LightRainAnimation(a);case "Cloud3":return new BalloonCloudAnimation(a);default:return new EmptyAnimation(a)}},getImagePath:function(a){return global.mbBaseURL+
a}}});
Class("BackgroundAnimation",{create:function(a){this.stage={body:a.stage,width:a.width,height:a.height};this.items=[];this.frameNumber=this.itemNumber=0;this.onCreated.delay(this,1)},onCreated:function(){this.resize(this.stage.width,this.stage.height)},resize:function(a,b){this.stage.width=a;this.stage.height=b;this.clear()},clear:function(){for(;0<this.items.length;){var a=this.items.pop();a&&a.destroy&&a.destroy()}this.items=[]},addItem:function(){this.items.length>=this.itemNumber||this.items.push(this.newItem())},getImagePath:function(a){return DynamicBackground.getImagePath(a)},
itemCount:function(){return this.items.length},getItem:function(a){return this.items[a]},nextFrame:virtual_function,newItem:virtual_function});
Class("BackgroundItem",{create:function(a){this.parent=a;this.initBody();this.initPositions()},initBody:function(){this.body=null;this.createBody();this.parent.body.append(this.body)},getImagePath:function(a){return DynamicBackground.getImagePath(a)},createBody:virtual_function,initPositions:virtual_function,move:virtual_function,refresh:virtual_function,pointByStep:function(a,b,c,d,e){return e?b+Number.fixed((c-b)*a/d,e):b+Math.floor((c-b)*a/d)},destroy:function(){this.body&&(this.body.remove(),
this.body=null)}});Class("BackgroundItemPosition",{create:function(a,b,c,d){this.left=a||0;this.top=b||0;this.scale=c||1;this.rotate=d||0}});
Class("GoThroughAnimation",{create:function(a){this._super(a);this.count=0},nextFrame:function(){if(this.frameNumber&&this.itemNumber){this.itemNumber>this.frameNumber?this.addMultipleItems():this.addItemFewFrames();for(var a=0;a<this.items.length;a++)this.items[a].isActive()&&this.items[a].move()}},addMultipleItems:function(){var a=Math.floor(this.itemNumber/this.frameNumber);a=Math.max(a,1);for(var b=0;b<a;b++)this.addItem()},addItemFewFrames:function(){var a=Math.floor(this.frameNumber/this.itemNumber);
a=Math.max(a,1);++this.count==a&&(this.addItem(),this.count=0)},addItem:function(){for(var a=0;a<this.items.length;a++)if(this.items[a].isFree()){this.items[a].active();return}this.itemCount()>=this.itemNumber||(a=this.newItem(),a.active(),this.items.push(a))},newItem:virtual_function}).extend("BackgroundAnimation");
Class("GoThroughItem",{create:function(a,b){this._super(a);this.frameNumber=b||1;this.step=0;this.moving=!1},createBody:virtual_function,initPositions:virtual_function,refresh:virtual_function,move:function(){this.step++;this.step==this.frameNumber&&this.sleep();this.refresh()},isActive:function(){return 1==this.moving},isFree:function(){return 0==this.moving},sleep:function(){this.moving=!1},active:function(){this.step=1;this.moving=!0;this.initPositions();this.refresh()}}).extend("BackgroundItem");
Class("AlwaysExistsAnimation",{create:function(a){this._super(a)},addItems:function(){for(var a=0;a<this.itemNumber;a++)this.addItem()},nextFrame:function(){for(var a=0;a<this.items.length;a++)this.items[a].move()},resize:function(a,b){this._super(a,b);this.addItems()},newItem:virtual_function}).extend("BackgroundAnimation");
Class("AlwaysExistsItem",{create:function(a,b){this._super(a);this.frameNumber=b||1;this.step=1},createBody:virtual_function,initPositions:virtual_function,refresh:virtual_function,move:function(){this.step++;this.step==this.frameNumber&&(this.step=1,this.resetTarget());this.refresh()},resetTarget:function(){}}).extend("BackgroundItem");
Class("PetalsDancingAnimation",{create:function(a){this._super(a);this.frameNumber=this.itemNumber=200},newItem:function(){return new PetalsDancingItem(this.stage,this.frameNumber)}}).extend("GoThroughAnimation");
Class("PetalsDancingItem",{create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:30px;height:28px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("petal.png"))},initPositions:function(){var a=1.2*this.parent.width,b=1.2*this.parent.height,c=Math.floor(Math.sqrt(a*a+b*b));a=.1*-this.parent.width;b=Number.random(.1*-this.parent.height,Math.floor(.9*this.parent.height),0);var d=Number.random(10,20,1),e=Math.PI/180*d;
d=Math.floor(a+c*Math.cos(e));c=Math.floor(b+c*Math.sin(e));e=Number.fixed(.2+b/this.parent.height,1);var f=e-.2,g=Number.random(0,360,1),h=Number.random(0,360,1);this.start=new BackgroundItemPosition(a,b,e,g);this.end=new BackgroundItemPosition(d,c,f,h)},refresh:function(){var a=Math.floor($.easing.swing(null,this.step,this.start.left,this.end.left-this.start.left,this.frameNumber)),b=Math.floor($.easing.swing(null,this.step,this.start.top,this.end.top-this.start.top,this.frameNumber)),c=$.easing.swing(null,
this.step,this.start.scale,this.end.scale-this.start.scale,this.frameNumber),d=$.easing.swing(null,this.step,this.start.rotate,this.end.rotate-this.start.rotate,this.frameNumber);a=transformCSS({tran:{x:a,y:b},scale:c,rotate:d});this.body.css(a)}}).extend("GoThroughItem");Class("SlowBubbleAnimation",{create:function(a){this._super(a);this.itemNumber=50;this.frameNumber=200},newItem:function(){return new SlowBubbleItem(this.stage,this.frameNumber)}}).extend("GoThroughAnimation");
Class("SlowBubbleItem",{create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:50px;height:50px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("bubble.png"))},initPositions:function(){var a=Number.random(.3,.7),b=Number.random(20,this.parent.width-20);this.start=new BackgroundItemPosition(b,Math.floor(this.parent.height-50*a),a);this.end=new BackgroundItemPosition(b,-40,a)},refresh:function(){var a=$.easing.easeInSine(null,
this.step,this.start.left,this.end.left-this.start.left,this.frameNumber);var b=$.easing.easeInQuad(null,this.step,this.start.top,this.end.top-this.start.top,this.frameNumber);var c=$.easing.easeOutQuint(null,this.step,0,this.start.scale,this.frameNumber);a=transformCSS({tran:{x:a,y:b},scale:c,origin:{x:50,y:100}});this.body.css(a)}}).extend("GoThroughItem");
Class("FastBubbleAnimation",{create:function(a){this._super(a);this.itemNumber=80;this.frameNumber=40;this.popupPoints=[];this.popupPoints.push(.1*a.width);this.popupPoints.push(.9*a.width)},resize:function(a,b){this.popupPoints[0]=.1*a;this.popupPoints[1]=.9*a;this._super(a,b)},newItem:function(){return new FastBubbleItem(this.stage,this.frameNumber,this.popupPoints)}}).extend("GoThroughAnimation");
Class("FastBubbleItem",{create:function(a,b,c){this.points=c;this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:50px;height:50px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("blue_bubble.png"))},initPositions:function(){var a=Number.random(.2,.35,2),b=this.points[Number.random(.1,1.9,0)],c=Math.floor(this.parent.height-50*a),d=Math.floor(b+Number.random(-30,30));this.start=new BackgroundItemPosition(b,c,a);this.end=new BackgroundItemPosition(d,
-40,a)},refresh:function(){var a=$.easing.easeOutQuint(null,this.step,this.start.left,this.end.left-this.start.left,this.frameNumber);var b=$.easing.easeInQuad(null,this.step,this.start.top,this.end.top-this.start.top,this.frameNumber);var c=$.easing.easeOutQuint(null,this.step,0,this.start.scale,this.frameNumber);a=transformCSS({tran:{x:a,y:b},scale:c,origin:{x:50,y:100}});this.body.css(a)}}).extend("GoThroughItem");
Class("LightRainAnimation",{create:function(a){this._super(a);this.itemNumber=240;this.frameNumber=30},newItem:function(){return new LightRainItem(this.stage,this.frameNumber)}}).extend("GoThroughAnimation");
Class("LightRainItem",{create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:15px;height:24px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("raindrop.png"))},initPositions:function(){var a=Number.random(0,this.parent.width),b=Math.floor(this.parent.height+10);this.start=new BackgroundItemPosition(a,-50);this.end=new BackgroundItemPosition(a,b)},refresh:function(){var a=Math.floor($.easing.easeInSine(null,this.step,
this.start.left,this.end.left-this.start.left,this.frameNumber)),b=Math.floor($.easing.easeInSine(null,this.step,this.start.top,this.end.top-this.start.top,this.frameNumber));a=transformCSS({tran:{x:a,y:b}});this.body.css(a)}}).extend("GoThroughItem");Class("HeavyRainAnimation",{create:function(a){this._super(a);this.itemNumber=160;this.frameNumber=20},newItem:function(){return new HeavyRainItem(this.stage,this.frameNumber)}}).extend("AlwaysExistsAnimation");
Class("HeavyRainItem",{create:function(a,b){this.angle=15;this.radian=this.angle*Math.PI/180;this._super(a,b)},createBody:function(){this.body=$("<div style='left:0px;top:0px;width:2px;height:10px;position:absolute;z-index:1'></div>");this.body.css({border:"0px solid gray",height:Math.floor(this.parent.height/Math.cos(this.radian))+"px","background-color":"rgba(225,225,225, 0.06)"})},initPositions:function(){var a=Number.random(0,this.parent.width+Math.floor(this.parent.height*Math.tan(this.radian)));
this.start=new BackgroundItemPosition(a,0)},refresh:function(){var a=Number.random(0,this.parent.width+Math.floor(this.parent.height*Math.tan(this.radian)));a=transformCSS({tran:{x:a,y:0},origin:{x:0,y:0},rotate:this.angle});this.body.css(a)}}).extend("AlwaysExistsItem");Class("SpaceShipAnimation",{create:function(a){this._super(a);this.itemNumber=300;this.frameNumber=30;SpaceShipItem.initTrigons()},newItem:function(){return new SpaceShipItem(this.stage,this.frameNumber)}}).extend("AlwaysExistsAnimation");
Class("SpaceShipItem",{statics:{initTrigons:function(){this.trigons={};for(var a=0;360>=a;){var b=Number.fixed(a/180*Math.PI,3),c=1E3*b;b={sin:Math.sin(b),cos:Math.cos(b)};this.trigons[c]||(this.trigons[c]=b);a+=.05}}},create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:50px;height:50px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("star.png"))},initPositions:function(){this.orbitRadius=Number.random(0,this.maxOrbit(this.parent.width,
this.parent.height));this.radius=Number.random(90,this.orbitRadius)/20;this.orbitX=this.parent.width/2;this.orbitY=this.parent.height/2;this.angle=Number.random(0,360);this.speed=Number.random(0,this.orbitRadius/4)/this.orbitRadius;this.body.css({width:this.radius+"px",height:this.radius+"px",opacity:.8})},getTrigon:function(a){a=Number.fixed(a/180*Math.PI,3);return SpaceShipItem.trigons[1E3*a]},maxOrbit:function(a,b){a=Math.max(a,b);return Math.round(Math.sqrt(a*a+a*a))/2},move:function(){this.angle+=
this.speed;this.angle%=360;this.refresh()},refresh:function(){var a=this.getTrigon(this.angle);a&&(a=transformCSS({tran:{x:a.sin*this.orbitRadius+this.orbitX-this.radius/2,y:a.cos*this.orbitRadius+this.orbitY-this.radius/2}}),this.body.css(a))}}).extend("AlwaysExistsItem");
Class("SpaceTravelAnimation",{create:function(a){this._super(a);this.frameNumber=this.itemNumber=300},nextFrame:function(){if(this.frameNumber&&this.itemNumber){for(var a=0;2>a;a++)this.addItem();for(a=0;a<this.items.length;a++)this.items[a].isActive()&&this.items[a].move()}},newItem:function(){return new SpaceTravelItem(this.stage,this.frameNumber)}}).extend("GoThroughAnimation");
Class("SpaceTravelItem",{create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:50px;height:50px;position:absolute;z-index:1;opacity:0.8'></img>");this.body.attr("src",this.getImagePath("star.png"))},initPositions:function(){var a=this.maxOrbit(this.parent.width,this.parent.height),b=Math.floor(.7*a),c=Number.random(0,b);c=$.easing.easeInQuad(null,c,20,b-20,b);fScale=1-.8*c/b;fSpeed=5-4*c/b;this.realFrameNumber=Math.floor(this.frameNumber/fSpeed);
b=Number.random(0,360)/180*Math.PI;var d=this.parent.width/2,e=this.parent.height/2,f=Math.sin(b)*a+d;a=Math.cos(b)*a+e;this.start=new BackgroundItemPosition(Math.sin(b)*c+d,Math.cos(b)*c+e,.1);this.end=new BackgroundItemPosition(f,a,fScale)},maxOrbit:function(a,b){a=Math.max(a,b);return Math.round(Math.sqrt(a*a+a*a))/2},move:function(){this.step++;this.step==this.realFrameNumber&&this.sleep();this.refresh()},refresh:function(){var a=Math.floor($.easing.easeInSine(null,this.step,this.start.left,this.end.left-
this.start.left,this.realFrameNumber)),b=Math.floor($.easing.easeInSine(null,this.step,this.start.top,this.end.top-this.start.top,this.realFrameNumber)),c=$.easing.easeInSine(null,this.step,this.start.scale,this.end.scale-this.start.scale,this.realFrameNumber);a=transformCSS({tran:{x:a,y:b},scale:c});this.body.css(a)}}).extend("GoThroughItem");Class("MeteorAnimation",{create:function(a){this._super(a);this.itemNumber=3;this.frameNumber=120},newItem:function(){return new MeteorItem(this.stage,this.frameNumber)}}).extend("GoThroughAnimation");
Class("MeteorItem",{create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:-100px;width:2px;height:88px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("meteor.png"))},initPositions:function(){var a=Number.random(.5*this.parent.width,1.5*this.parent.width,0),b=Math.PI/180*65,c=Math.floor(this.parent.height+88*Math.cos(b));b=Math.floor(a-c*Math.tan(b));var d=Number.random(.7,1.5,1);this.start=new BackgroundItemPosition(a,0,d,
65);this.end=new BackgroundItemPosition(b,c,d,65)},refresh:function(){var a=Math.floor(this.frameNumber);if(!(this.step>a)){var b=Math.floor($.easing.easeInSine(null,this.step,this.start.left,this.end.left-this.start.left,a)),c=Math.floor($.easing.easeInSine(null,this.step,this.start.top,this.end.top-this.start.top,a));$.easing.easeInSine(null,this.step,1,-1,a);a=transformCSS({origin:{x:0,y:0},tran:{x:b,y:c},rotate:this.start.rotate,scale:this.start.scale});this.body.css(a)}}}).extend("GoThroughItem");
Class("SunshineAnimation",{create:function(a){this._super(a);this.createSun();this.createSunBorder();this.itemNumber=40;this.frameNumber=10},createSun:function(){this.sun=$("<div></div>");this.sun.css({position:"absolute","z-index":2,width:"4px",height:"4px","border-radius":"2px","background-color":"rgba(255,255,255, 0.9)",left:"-4px",top:"-4px","box-shadow":"0px 0px 50px 130px rgba(255,255,255, 0.9)","-o-box-shadow":"0px 0px 50px 130px rgba(255,255,255, 0.9)","-ms-box-shadow":"0px 0px 50px 130px rgba(255,255,255, 0.9)",
"-moz-box-shadow":"0px 0px 50px 130px rgba(255,255,255, 0.9)","-webkit-box-shadow":"0px 0px 50px 130px rgba(255,255,255, 0.9)",opacity:1});this.stage.body.append(this.sun)},createSunBorder:function(){this.sunBorder=$("<div></div>");this.sunBorder.css({position:"absolute","z-index":1,width:"4px",height:"4px","border-radius":"2px","background-color":"rgba(255,255,255, 0.2)",left:"-4px",top:"-4px","box-shadow":"0px 0px 200px 500px rgba(255,255,255, 0.2)","-o-box-shadow":"0px 0px 200px 500px rgba(255,255,255, 0.2)",
"-ms-box-shadow":"0px 0px 200px 500px rgba(255,255,255, 0.2)","-moz-box-shadow":"0px 0px 200px 500px rgba(255,255,255, 0.2)","-webkit-box-shadow":"0px 0px 200px 500px rgba(255,255,255, 0.2)",opacity:1});this.stage.body.append(this.sunBorder)},newItem:function(){var a=this.itemCount()<this.itemNumber/2?1:-1;return new SunshineHaloItem(this.stage,this.frameNumber,a)}}).extend("AlwaysExistsAnimation");
Class("SunshineHaloItem",{create:function(a,b,c){this.direction=c;this._super(a,b)},createBody:function(){this.body=$("<div style='left:0px;top:0px;width:0px;height:5px;position:absolute;z-index:2'></div>");this.body.css({"border-left":"0px solid rgba(0,0,0,0)","border-right":Math.floor(Math.sqrt(this.parent.width*this.parent.width+this.parent.height*this.parent.height))+"px solid rgba(255,255,255,0.01)","border-top":"25px solid rgba(0,0,0,0)","border-bottom":"25px solid rgba(0,0,0,0)","transform-origin":"0% 0%"})},
initPositions:function(){this.rotate=Number.random(0,90)},move:function(){this.rotate+=this.direction/this.frameNumber;0>this.rotate&&(this.rotate+=90);this.rotate%=90;this.refresh()},refresh:function(){var a=this.rotate,b=Math.PI/180*a;a=transformCSS({tran:{x:Math.floor(120*Math.cos(b)),y:Math.floor(120*Math.sin(b))-20},rotate:a});this.body.css(a)}}).extend("AlwaysExistsItem");
Class("CloudAnimation",{create:function(a){this._super(a);this.itemNumber=10;this.frameNumber=1E3},resize:function(a,b){this._super(a,b);for(a=0;a<this.itemNumber;a++)this.addItem();for(a=0;a<this.itemCount();a++){b=this.getItem(a);var c=this.frameNumber-Math.floor((a+1)*this.frameNumber/this.itemNumber);b.active();b.step=c;b.refresh()}},newItem:function(){return new CloudItem(this.stage,this.frameNumber,this.itemCount()%5)}}).extend("GoThroughAnimation");
Class("CloudItem",{create:function(a,b,c){this.cloudType=c;this.initCloudResources();this._super(a,b)},initCloudResources:function(){this.cloudResources=[];this.cloudResources.push({src:"cloud5.png",width:300,height:147,top:.3});this.cloudResources.push({src:"cloud4.png",width:300,height:112,top:.5});this.cloudResources.push({src:"cloud2.png",width:300,height:211,top:.1});this.cloudResources.push({src:"cloud3.png",width:300,height:208,top:.2});this.cloudResources.push({src:"cloud1.png",width:300,
height:177,top:0})},createBody:function(){this.body=$("<img style='left:0px;top:0px;position:absolute;z-index:1'></img>");var a=this.cloudResources[this.cloudType],b={width:a.width+"px",height:a.height+"px"};this.body.attr("src",this.getImagePath(a.src));this.body.css(b);this.top=a.top;this.width=a.width;this.height=a.height},initPositions:function(){var a=this.parent.width+100,b=Math.floor(this.parent.height*this.top),c=-this.width;Number.random(0,360);Number.random(-90,90);this.start=new BackgroundItemPosition(a,
b);this.end=new BackgroundItemPosition(c,b)},refresh:function(){var a=this.pointByStep(this.step,this.start.left,this.end.left,this.frameNumber),b=this.pointByStep(this.step,this.start.top,this.end.top,this.frameNumber);a=transformCSS({tran:{x:a,y:b},scale:this.start.scale});this.body.css(a)}}).extend("GoThroughItem");
Class("SunCloudAnimation",{create:function(a){this.sun=new SunshineAnimation(a);this.cloud=new CloudAnimation(a)},resize:function(a,b){this.sun.resize(a,b);this.cloud.resize(a,b)},nextFrame:function(){this.sun.nextFrame();this.cloud.nextFrame()}});
Class("SnowAnimation",{create:function(a){this._super(a);this.itemNumber=200;this.frameNumber=400},resize:function(a,b){this._super(a,b);for(a=0;a<this.itemNumber;a++)this.addItem();for(a=0;a<this.itemCount();a++){b=this.getItem(a);var c=Number.random(0,this.frameNumber);b.active();b.step=c;b.refresh()}},newItem:function(){return new SnowItem(this.stage,this.frameNumber)}}).extend("GoThroughAnimation");
Class("SnowItem",{create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:22px;height:22px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("snow.png"))},initPositions:function(){var a=1.2*this.parent.height,b=Number.random(0,this.parent.width),c=Math.floor(.1*-this.parent.height),d=Number.random(80,100,1),e=Math.PI/180*d;d=Math.floor(b+a*Math.cos(e));a=Math.floor(c+a*Math.sin(e));e=Number.random(.3,1.5);this.start=new BackgroundItemPosition(b,
c,e);this.end=new BackgroundItemPosition(d,a,e)},refresh:function(){var a=this.pointByStep(this.step,this.start.left,this.end.left,this.frameNumber),b=this.pointByStep(this.step,this.start.top,this.end.top,this.frameNumber);a=transformCSS({tran:{x:a,y:b},scale:this.start.scale});this.body.css(a)}}).extend("GoThroughItem");Class("FireflyAnimation",{create:function(a){this._super(a);this.itemNumber=50;this.frameNumber=300},newItem:function(){return new FireflyItem(this.stage,this.frameNumber)}}).extend("AlwaysExistsAnimation");
Class("FireflyItem",{create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:30px;height:30px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("firefly.png"))},initPositions:function(){var a=Number.random(0,this.parent.width),b=Number.random(this.parent.height/3,this.parent.height),c=Number.random(.3,1,1);this.start=new BackgroundItemPosition(a,b,c);this.end=null;this.resetTarget()},resetTarget:function(){this.end&&(this.start=
this.end,this.end=null);var a=Number.random(0,35),b=Math.PI/180*a;a=this.start.left+[-1,1][Number.random(.1,1.9,0)]*Math.floor(80*Math.cos(b));a=Number.between(a,-20,this.parentWidth+20);b=this.start.top+[-1,1][Number.random(.1,1.9,0)]*Math.floor(80*Math.sin(b));b=Number.between(b,-20,this.parent.height+20);var c=Number.random(.3,1,1);this.end=new BackgroundItemPosition(a,b,c)},refresh:function(){var a=this.pointByStep(this.step,this.start.left,this.end.left,this.frameNumber);var b=this.pointByStep(this.step,
this.start.top,this.end.top,this.frameNumber);var c=$.easing.swing(null,this.step,this.start.scale,this.end.scale-this.start.scale,this.frameNumber);a=transformCSS({tran:{x:a,y:b},scale:c});this.body.css(a)}}).extend("AlwaysExistsItem");Class("FallenLeavesAnimation",{create:function(a){this._super(a);this.itemNumber=25;this.frameNumber=300},newItem:function(){return new FallenLeavesItem(this.stage,this.frameNumber)}}).extend("GoThroughAnimation");
Class("FallenLeavesItem",{create:function(a,b){this.initLeafResources();this._super(a,b)},initLeafResources:function(){this.leafResources=[];this.leafResources.push({src:"leaves1.png",width:99,height:59});this.leafResources.push({src:"leaves2.png",width:100,height:88});this.leafResources.push({src:"leaves3.png",width:100,height:60});this.leafResources.push({src:"leaves4.png",width:100,height:87});this.leafResources.push({src:"leaves5.png",width:100,height:87});this.leafResources.push({src:"leaves6.png",
width:100,height:57})},createBody:function(){this.body=$("<img style='left:0px;top:0px;position:absolute;z-index:1'></img>");var a=this.leafResources[Number.random(.1,5.9,0)],b={width:a.width+"px",height:a.height+"px"};this.body.attr("src",this.getImagePath(a.src));this.body.css(b)},initPositions:function(){var a=1.2*this.parent.height,b=Number.random(0,this.parent.width),c=Math.floor(.1*-this.parent.height),d=Number.random(80,100,1),e=Math.PI/180*d;d=Math.floor(b+a*Math.cos(e));a=Math.floor(c+a*
Math.sin(e));e=Number.random(.4,.8,1);var f=Number.random(0,360),g=f+Number.random(-90,90);this.start=new BackgroundItemPosition(b,c,e,f);this.end=new BackgroundItemPosition(d,a,e,g)},refresh:function(){var a=$.easing.easeInSine(null,this.step,this.start.left,this.end.left-this.start.left,this.frameNumber),b=$.easing.easeInSine(null,this.step,this.start.top,this.end.top-this.start.top,this.frameNumber),c=$.easing.easeInSine(null,this.step,this.start.rotate,this.end.rotate-this.start.rotate,this.frameNumber);
a=transformCSS({tran:{x:a,y:b},scale:this.start.scale,rotate:c});this.body.css(a)}}).extend("GoThroughItem");Class("TwinkleAnimation",{create:function(a){this._super(a);this.itemNumber=8;this.frameNumber=100},newItem:function(){return new TwinkleItem(this.stage,this.frameNumber)}}).extend("GoThroughAnimation");
Class("TwinkleItem",{create:function(a,b){this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:26px;height:26px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("twinkle.png"))},initPositions:function(){var a=Number.random(0,this.parent.width),b=Number.random(0,this.parent.height),c=Number.random(0,360),d=c+360;this.start=new BackgroundItemPosition(a,b,1,c);this.end=new BackgroundItemPosition(a,b,1,d)},refresh:function(){var a=this.start.left,
b=this.start.top,c=this.pointByStep(this.step,this.start.rotate,this.end.rotate,this.frameNumber,1),d=this.step,e=this.frameNumber/2;d=d<e?this.pointByStep(d,0,1,e,1):this.pointByStep(d-e,1,0,e,1);a=transformCSS({tran:{x:a,y:b},scale:d,rotate:c});this.body.css(a)}}).extend("GoThroughItem");
Class("MoonCloudAnimation",{create:function(a){this._super(a);this.itemNumber=9;this.frameNumber=1800;this.createMoon()},createMoon:function(){this.moon=$("<img></img>");this.moon.attr("src",this.getImagePath("moon.png"));this.moon.css({position:"absolute",right:"2%",top:"2%"});this.stage.body.append(this.moon)},resize:function(a,b){this._super(a,b);for(a=0;a<this.itemNumber;a++)this.addItem();for(a=0;a<this.itemCount();a++){b=this.getItem(a);var c=this.frameNumber-Math.floor((a+1)*this.frameNumber/
this.itemNumber);b.active();b.step=c;b.refresh()}},newItem:function(){return new MoonCloudItem(this.stage,this.frameNumber,this.itemCount()%3)}}).extend("GoThroughAnimation");
Class("MoonCloudItem",{create:function(a,b,c){this.initCloudResources();this.cloudType=c;this._super(a,b)},initCloudResources:function(){this.cloudResources=[];this.cloudResources.push({src:"moon_cloud_one.png",width:960,height:480,top:.05,opacity:.5});this.cloudResources.push({src:"moon_cloud_two.png",width:960,height:480,top:.05,opacity:.2});this.cloudResources.push({src:"moon_cloud_three.png",width:960,height:480,top:.05,opacity:.5})},createBody:function(){this.body=$("<img style='left:0px;top:0px;position:absolute;z-index:1'></img>");
var a=this.cloudResources[this.cloudType],b={width:a.width+"px",height:a.height+"px",opacity:a.opacity};this.body.attr("src",this.getImagePath(a.src));this.body.css(b);this.top=a.top;this.width=a.width;this.height=a.height},initPositions:function(){var a=this.parent.width,b=Math.floor(this.parent.height*this.top),c=-this.width;Number.random(0,360);Number.random(-90,90);this.speed=Number.random(1,2,1);this.realFrameNumber=Math.floor(this.frameNumber/this.speed);this.start=new BackgroundItemPosition(a,
b);this.end=new BackgroundItemPosition(c,b)},refresh:function(){if(!(this.step>this.realFrameNumber)){var a=this.pointByStep(this.step,this.start.left,this.end.left,this.realFrameNumber),b=this.pointByStep(this.step,this.start.top,this.end.top,this.realFrameNumber);a=transformCSS({tran:{x:a,y:b},scale:this.start.scale});this.body.css(a)}}}).extend("GoThroughItem");
Class("BalloonCloudAnimation",{create:function(a){this.balloon=new BalloonAnimation(a);this.cloud=new BottomCloudAnimation(a)},resize:function(a,b){this.balloon.resize(a,b);this.cloud.resize(a,b)},nextFrame:function(){this.balloon.nextFrame();this.cloud.nextFrame()}});Class("BalloonAnimation",{create:function(a){this._super(a);this.itemNumber=2;this.frameNumber=600},newItem:function(){return new BalloonItem(this.stage,this.frameNumber,this.itemCount())}}).extend("AlwaysExistsAnimation");
Class("BalloonItem",{create:function(a,b,c){this.index=c;this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:150px;height:150px;position:absolute;z-index:1'></img>");this.body.attr("src",this.getImagePath("air_balloon.png"))},initPositions:function(){var a=this.parent.width/1E3,b=Math.floor(125*a),c=Math.floor(140*a);a=0==this.index?Number.random(20,100):this.parent.width-200-Number.random(20,100);c=this.parent.height-b-c;var d=Number.random(30,70),e=c+d;this.start=
new BackgroundItemPosition(a,c-d);this.end=new BackgroundItemPosition(a,e);this.body.css({width:b+"px",height:b+"px"})},refresh:function(){var a=this.frameNumber/2,b=this.step;if(b<=a){var c=this.pointByStep(b,this.start.left,this.end.left,a);a=this.pointByStep(b,this.start.top,this.end.top,a)}else b-=a,c=this.pointByStep(b,this.end.left,this.start.left,a),a=this.pointByStep(b,this.end.top,this.start.top,a);c=transformCSS({tran:{x:c,y:a},origin:{x:0,y:0}});this.body.css(c)}}).extend("AlwaysExistsItem");
Class("BottomCloudAnimation",{create:function(a){this._super(a);this.itemNumber=2;this.frameNumber=1E3},newItem:function(){return new BottomCloudItem(this.stage,this.frameNumber,this.itemCount())}}).extend("AlwaysExistsAnimation");
Class("BottomCloudItem",{create:function(a,b,c){this.index=c;this._super(a,b)},createBody:function(){this.body=$("<img style='left:0px;top:0px;width:256px;height:256px;position:absolute;z-index:2'></img>");this.body.attr("src",this.getImagePath("bg-clouds.png"))},initPositions:function(){var a=this.parent.width,b=188*this.parent.width/988,c=this.index*this.parent.width,d=this.parent.height-b,e=c-this.parent.width;this.start=new BackgroundItemPosition(c,d);this.end=new BackgroundItemPosition(e,d);
this.body.css({width:a+"px",height:b+"px"})},refresh:function(){iX=this.pointByStep(this.step,this.start.left,this.end.left,this.frameNumber);iY=this.pointByStep(this.step,this.start.top,this.end.top,this.frameNumber);var a=transformCSS({tran:{x:iX,y:iY},origin:{x:0,y:0}});this.body.css(a)}}).extend("AlwaysExistsItem");Class("EmptyAnimation",{create:function(a){},addItem:function(){},clear:function(){},resize:function(a,b){},nextFrame:function(){},newItem:function(){}}).extend("BackgroundAnimation");
